#ifndef _ltc2600spi_h_
#define _ltc2600spi_h_ 1


//Use these by ORing the Command and the Address together and sending as first byte


/* 
** SPI Command Operations
** Defined as the top nibble of the first byte
*/
#define LTC2600_CMD_WRITE_N                           (0x00)
#define LTC2600_CMD_UPDATE_N                          (0x10)
#define LTC2600_CMD_WRITE_UPDATE_ALL                  (0x20)
#define LTC2600_CMD_WRITE_UPDATE_N                    (0x30)
#define LTC2600_CMD_POWER_DOWN_N                      (0x40)
#define LTC2600_CMD_NO_OPERATION                      (0xF0)


/* 
** SPI Address Operations
** Defined as the bottom of the first byte
*/
#define LTC2600_ADR_DAC_A                         (0x00)
#define LTC2600_ADR_DAC_B                         (0x01)
#define LTC2600_ADR_DAC_C                         (0x02)
#define LTC2600_ADR_DAC_D                         (0x03)
#define LTC2600_ADR_DAC_E                         (0x04)
#define LTC2600_ADR_DAC_F                         (0x05)
#define LTC2600_ADR_DAC_G                         (0x06)
#define LTC2600_ADR_DAC_H                         (0x07)
#define LTC2600_ADR_DAC_ALL                       (0x0F)





//Channel Lookup
static const uint_8 LTC2600CommandSelect[] = 
{
	LTC2600_CMD_WRITE_N,
	LTC2600_CMD_UPDATE_N,
	LTC2600_CMD_WRITE_UPDATE_ALL,
	LTC2600_CMD_WRITE_UPDATE_N,
	LTC2600_CMD_POWER_DOWN_N,
	LTC2600_CMD_NO_OPERATION
};

//Span Lookup
static const uint_8 LTC2600ChannelSelect[] = 
{
	LTC2600_ADR_DAC_A,
	LTC2600_ADR_DAC_B,
	LTC2600_ADR_DAC_C,
	LTC2600_ADR_DAC_D,
	LTC2600_ADR_DAC_E,
	LTC2600_ADR_DAC_F,
	LTC2600_ADR_DAC_G,
	LTC2600_ADR_DAC_H,
	LTC2600_ADR_DAC_ALL

};


//Function Definitions

extern uint_32		send_LTC2600 (uint_8, uint_8, uint_32, FILE_PTR);
extern uint_32		send_receive_LTC2600 (uint_8, uint_8, uint_32, FILE_PTR);


#endif /* _ltc2600spi_h_ */

